
/* revised to use j=0;j<n for data[j]
/* H. Fang 07.31.2010*/

#include <math.h>
#include "nrutil.h"
#define BIG 1.0e30

extern int nn;
extern float *xx,*yy,*sx,*sy,*ww,aa,offs;

float chixy(float bang)
{
  int j;
  float ans,avex=0.0,avey=0.0,sumw=0.0,b;

  b=tan(bang);
  for (j=0;j<nn;j++) {
    ww[j] = SQR(b*sx[j])+SQR(sy[j]);
    sumw += (ww[j] = (ww[j] < 1.0/BIG ? BIG : 1.0/ww[j]));
    avex += ww[j]*xx[j];
    avey += ww[j]*yy[j];
  }
  avex /= sumw;
  avey /= sumw;
  aa=avey-b*avex;
  for (ans = -offs,j=0;j<nn;j++) {
    ans += ww[j]*SQR(yy[j]-aa-b*xx[j]);
/*
printf("\n chixy %6.2f%10.4f%10.4f%6.2f%6.2f%6.2f",
       ww[j],aa,b,xx[j],yy[j],ans);   
*/  
  }
  return ans;
}
