#include <math.h>
#define ITMAX 100
#define EPS 3.0e-7
#define FPMIN 1.0e-30

void gcf(float *gammcf, float a, float x, float *gln)
{
  float gammln(float xx);
  void nrerror(char error_text[]);
  int i;
  float an,b,c,d,del,h;

  *gln=gammln(a);
  b=x+1.0-a;
  c=1.0/FPMIN;
  d=1.0/b;
  h=d;
  for (i=1;i<=ITMAX;i++) {
    an = -i*(i-a);
    b += 2.0;
    d=an*d+b;
    if (fabs(d) < FPMIN) d=FPMIN;
    c=b+an/c;
    if (fabs(c) < FPMIN) c=FPMIN;
    d=1.0/d;
    del=d*c;
    h *= del;
/*
  printf("gcf %3d%6.2f%8.0f%6.2f%6.2f%6.2f%6.2f%6.2f%12.4e\n",
          i,a,an,b,c,d,del,h,fabs(del-1.0));
*/
    if (fabs(del-1.0) < EPS) break;
  }
/*  if (i > ITMAX) nrerror("a too large, ITMAX too small in gcf");
*/
  if (i > ITMAX) nrerror("a too large, check sigx, sigy in fitexy");
  *gammcf=exp(-x+a*log(x)-(*gln))*h; 
}

