/* return field containing calibration and error numbers
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

float mean(float *a,int n);
void deviation (float *a,float mean,int n,float *d,float *S);

void linfit(float *x,float *y,int n,
    float *corr_coeff,float *reg_offset_yx,float *reg_coeff_yx)
{
  float sy,sx,mean_x,mean_y,sum_xy=0;
  float dx[n],dy[n];
  int i;   

  mean_x=mean(x,n);
  mean_y=mean(y,n);
  deviation(x,mean_x,n,dx,&sx);
  deviation(y,mean_y,n,dy,&sy);

  for(i=0;i<n;i++)
    sum_xy=sum_xy+dx[i]*dy[i];

  if (n*sx*sy == 0) 
    *corr_coeff = -98.0;
  else
    *corr_coeff = sum_xy/(n*sx*sy);

  if (sx == 0) {
    *reg_coeff_yx = 9999.0;
    *reg_offset_yx = 9999.0;    
  }
  else {
    *reg_coeff_yx = *corr_coeff*(sy/sx);
    *reg_offset_yx = mean_y - *reg_coeff_yx * mean_x;
  }
}

float mean(float *a, int n)
{
  int i;
  float sum=0.0;

  for(i=0;i<n;i++) {
    sum += a[i];
  }
  sum=sum/n;
  return (sum);

}

void deviation(float *a, float mean, int n, float *d, float *s)
{
  int i;
  float sum=0,t;

  for(i=0;i<n;i++) {  
    d[i]=a[i]-mean;
    t=d[i]*d[i];
    sum += t;
  }
  sum = sum/n;
  *s=sqrt(sum);

} 
