/* return field containing calibration and error numbers
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
   
#define XTILE 1000
#define YTILE 1000
#define XDIM 36000
#define YDIM 13101  /* 56S ~ 75N */
#define NN 20
#define NY 2
#define NW 5

char dir_bin[]="/disk2/weiss/Triple/Asia";
char fs_out[]="/disk2/fanghl/Triple/data";
char MCD_File[80],VGT_File[80],GC_File[80];
char fout1[100],fout2[100];

static char f_np[]="/disk2/fanghl/Triple/data/np.globe.0.05D";

main (int argc, char *argv[])
{
  void triplecol(float *,float *,float *,int,
     float, float, float, float,float []);
  void linfit(float *,float *,int,float *,float *,float *);

  int i,j,k,m,n,np;
  int imon,iw,jw,iy;
  float co_xy,co_xz,co_yz;
  float y_a,y_b,z_a,z_b,t_a,t_b;
  float lin_cal[3],tcem_cal[3];
  float x[NY*NW*NW],y[NY*NW*NW],z[NY*NW*NW];
  float dum1,dum2,dum3,varx,vary,varz;
  unsigned char OneLine1[XTILE],OneLine2[XTILE],OneLine3[XTILE];
  unsigned char ***mod,***vgt,***glc,ch;
  FILE *fm[NY],*fv[NY],*fg[NY],*fnp,*fp1[3],*fp2[3];
  
/*  printf("Initialization\n");
*/
  mod = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  vgt = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  glc = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  for (k=0;k<NY;k++) {
    mod[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YTILE);
    vgt[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YTILE);
    glc[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YTILE);
    for (i=0;i<YDIM;i++) {
      mod[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XTILE);
      vgt[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XTILE);
      glc[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XTILE);
  }}

  fnp=fopen(f_np,"wb");
  for (k=0;k<3;k++) {
    sprintf(fout1,"%s/lin%d.globe.0.05D",fs_out,k);
    sprintf(fout2,"%s/tcem%d.globe.0.05D",fs_out,k);
    fp1[k]=fopen(fout1,"wb");
    fp2[k]=fopen(fout2,"wb");
  }

/* loop to read files */

  for (iy=0;iy<NY;iy++) {
    sprintf(MCD_File,"%s/MCD15.globe.%4d_0.01D_Asia_10D",dir_bin,iy+2003);
    sprintf(VGT_File,"%s/VGT.globe.%4d_0.01D_Asia_10D",dir_bin,iy+2003);
    sprintf(GC_File,"%s/GC.globe.%4d_0.01D_Asia_10D",dir_bin,iy+2003);
    fm[iy]=fopen(MCD_File,"rb");
    fv[iy]=fopen(VGT_File,"rb");
    fg[iy]=fopen(GC_File,"rb");
  } 

  for (imon=0;imon<12;imon++) {
    for (i=0;i<YTILE;i++) {
      for (iy=0;iy<NY;iy++) {
        fread(OneLine1,sizeof(unsigned char),XTILE,fm[iy]); 
        fread(OneLine2,sizeof(unsigned char),XTILE,fv[iy]); 
        fread(OneLine3,sizeof(unsigned char),XTILE,fg[iy]); 
        for (j=0;j<XTILE;j++) {
          mod[iy][i][j] = OneLine1[j];
          vgt[iy][i][j] = OneLine2[j];
          glc[iy][i][j] = OneLine3[j];
        }
      }
    }

    for (i=0;i<YTILE;i+=NW)
      for (j=0;j<XTILE;j+=NW) { 
        np=0;  
        for (k=0;k<3;k++) {
          lin_cal[k] = -99.0;
          tcem_cal[k] = -99.0;
        }
      
/*        printf("%6d%6d\n",i,j);  */ 

        for (iw=0;iw<NW;iw++)
          for (jw=0;jw<NW;jw++) {

            for (iy=0;iy<NY;iy++) {
/*
           printf("%6d%6d%6d\n",mod[iy][i+iw][j+jw],
              vgt[iy][i+iw][j+jw],glc[iy][i+iw][j+jw]);
*/
              if (mod[iy][i+iw][j+jw] < 180 &&
                vgt[iy][i+iw][j+jw] < 180 &&
                glc[iy][i+iw][j+jw] < 180) {
                  x[np] = (float) mod[iy][i+iw][j+jw] * 0.1;
                  y[np] = (float) vgt[iy][i+iw][j+jw] * 0.1;
                  z[np] = (float) glc[iy][i+iw][j+jw] * 0.1 - 0.1;
/*        printf("%6d%6.2f%6.2f%6.2f\n",np,x[np],y[np],z[np]);
*/
                  np++;
              }
            } 
        }

        if (np > NN ) {
          linfit(x,y,np,&co_xy,&y_a,&y_b);
          linfit(x,z,np,&co_xz,&z_a,&z_b);
          linfit(y,z,np,&co_yz,&t_a,&t_b);
          lin_cal[0] = co_xy;
          lin_cal[1] = co_xz;
          lin_cal[2] = co_yz;
/*printf("A %8.4f%8.4f%8.4f\n",lin_cal[0],lin_cal[1],lin_cal[2]);
*/
          avevar(y,np,&dum2,&vary);
          avevar(z,np,&dum3,&varz);
/*printf("B %8.4f%8.4f\n",vary,varz);
*/
          if (vary ==0 || varz==0) {
              tcem_cal[0] = -98;
              tcem_cal[1] = -98;
              tcem_cal[2] = -98;
          }
/*          else if (co_xy >= 0.2 && co_xz >= 0.2 && co_yz >= 0.2)
*/
          else if (co_xy > 0 && co_xz > 0 && co_yz > 0)
            triplecol(x,y,z,np,y_a,y_b,z_a,z_b,tcem_cal);
          else {
              tcem_cal[0] = -97;
              tcem_cal[1] = -97;
              tcem_cal[2] = -97;
            }
        }

        ch = (unsigned char) np;
        fwrite(&ch,sizeof(unsigned char),1,fnp);
        for (k=0;k<3;k++) {
/*
 printf("%6d%8.2f%8.2f\n",k,lin_cal[k],tcem_cal[k]);
*/
          fwrite(&lin_cal[k],sizeof(float),1,fp1[k]);
          fwrite(&tcem_cal[k],sizeof(float),1,fp2[k]);

        }
    }
  }     
  
  for (iy=0;iy<NY;iy++) {
    fclose(fm[iy]); 
    fclose(fv[iy]); 
    fclose(fg[iy]);
  }
  fclose(fnp); 
  for (k=0;k<3;k++) {
    fclose(fp1[k]); 
    fclose(fp2[k]);
  }

}
