/* return field containing calibration and error numbers
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
   
#define XDIM 36000
#define YDIM 13101  /* 56S ~ 75N */
#define NN 60       /* points used in TCEM*/
#define NY 5        /* # of years */
#define NMON 12     /* # of month */
#define NW 5        /* Upscale window size */

char dir_bin[]="/disk2/weiss/Triple/Globe";
char fs_out[]="/disk2/fanghl/Triple2/data";
char MCD_File[80],VGT_File[80],GC_File[80];
char fout1[100],fout2[100];

static char f_np[]="/disk2/fanghl/Triple2/data/np.globe.0.05D";

main (int argc, char *argv[])
{
  void triplecol(float *,float *,float *,int,
     float, float, float, float,float []);
  void linfit(float *,float *,int,float *,float *,float *);

  int i,j,k,m,n,np;
  int imon,iw,jw,iy;
  float co_xy,co_xz,co_yz;
  float y_a,y_b,z_a,z_b,t_a,t_b;
  float lin_cal[3],tcem_cal[3];
  float x[NY*NW*NW],y[NY*NW*NW],z[NY*NW*NW];
  float dum1,dum2,dum3,varx,vary,varz;
  unsigned char OneLine1[XDIM],OneLine2[XDIM],OneLine3[XDIM];
  unsigned char ***mod,***vgt,***glc,ch;
  FILE *fm[NY],*fv[NY],*fg[NY],*fnp,*fp1[3],*fp2[3];
  
/*  printf("Initialization\n");
*/
  mod = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  vgt = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  glc = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  for (k=0;k<NY;k++) {
    mod[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    vgt[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    glc[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    for (i=0;i<YDIM;i++) {
      mod[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
      vgt[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
      glc[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
  }}

  fnp=fopen(f_np,"wb");
  for (k=0;k<3;k++) {
    sprintf(fout1,"%s/lin%d.globe.0.05D",fs_out,k);
    sprintf(fout2,"%s/tcem%d.globe.0.05D",fs_out,k);
    fp1[k]=fopen(fout1,"wb");
    fp2[k]=fopen(fout2,"wb");
  }

/* loop to read files */

  for (iy=0;iy<NY;iy++) {
    sprintf(MCD_File,"%s/MCD15.globe.main.%4d_0.01D",dir_bin,iy+2003);
    sprintf(VGT_File,"%s/VGT.globe.%4d_0.01D",dir_bin,iy+2003);
    sprintf(GC_File,"%s/GC.globe.%4d_0.01D",dir_bin,iy+2003);
    fm[iy]=fopen(MCD_File,"rb");
    fv[iy]=fopen(VGT_File,"rb");
    fg[iy]=fopen(GC_File,"rb");
  } 

  for (imon=0;imon<NMON;imon++) {
    for (i=0;i<YDIM;i++) {
      for (iy=0;iy<NY;iy++) {
        fread(OneLine1,sizeof(unsigned char),XDIM,fm[iy]); 
        fread(OneLine2,sizeof(unsigned char),XDIM,fv[iy]); 
        fread(OneLine3,sizeof(unsigned char),XDIM,fg[iy]); 
        for (j=0;j<XDIM;j++) {
          mod[iy][i][j] = OneLine1[j];
          vgt[iy][i][j] = OneLine2[j];
          glc[iy][i][j] = OneLine3[j];
        }
      }
    }

    for (i=0;i<YDIM-1;i+=NW)
      for (j=0;j<XDIM;j+=NW) { 
        np=0;  
        for (k=0;k<3;k++) {
          lin_cal[k] = -99.0;
        }
/*      
        printf("%6d%6d",i,j);   
*/
        for (iw=0;iw<NW;iw++)
          for (jw=0;jw<NW;jw++) {

            for (iy=0;iy<NY;iy++) {
/*
           printf("%6d%6d%6d\n",mod[iy][i+iw][j+jw],
              vgt[iy][i+iw][j+jw],glc[iy][i+iw][j+jw]);
*/
              if (mod[iy][i+iw][j+jw] < 180 &&
                vgt[iy][i+iw][j+jw] < 180 &&
                glc[iy][i+iw][j+jw] < 180 && 
                glc[iy][i+iw][j+jw] > 0) {
                  x[np] = (float) mod[iy][i+iw][j+jw] * 0.1;
                  y[np] = (float) vgt[iy][i+iw][j+jw] * 0.1;
                  z[np] = (float) glc[iy][i+iw][j+jw] * 0.1 - 0.1;
/*        printf("%6d%6.2f%6.2f%6.2f\n",np,x[np],y[np],z[np]);
*/
                  np++;
              }
            } 
        }

        if (np > NN ) {
          linfit(x,y,np,&co_xy,&y_a,&y_b);
          linfit(x,z,np,&co_xz,&z_a,&z_b);
          linfit(y,z,np,&co_yz,&t_a,&t_b);
          lin_cal[0] = co_xy;
          lin_cal[1] = co_xz;
          lin_cal[2] = co_yz;
        }

        ch = (unsigned char) np;
        fwrite(&ch,sizeof(unsigned char),1,fnp);
        for (k=0;k<3;k++) {
          fwrite(&lin_cal[k],sizeof(float),1,fp1[k]);

        }
    }
  }     
  
  for (iy=0;iy<NY;iy++) {
    fclose(fm[iy]); 
    fclose(fv[iy]); 
    fclose(fg[iy]);
  }
  fclose(fnp); 
  for (k=0;k<3;k++) {
    fclose(fp1[k]); 
  }

}
