/* return field containing calibration and error numbers
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
   
#define XDIM 36000
#define YDIM 13101  /* 56S ~ 75N */
#define NN 60       /* points used in TCEM*/
#define NY 5        /* # of years */
#define NMON 12     /* # of month */
#define NW 5        /* Upscale window size */

char dir_bin[]="/disk2/weiss/Triple/Globe";
char fs_out[]="/disk2/fanghl/Triple2/data";
char MCD_File[80],VGT_File[80],GC_File[80];
char fout1[100],fout2[100];

main (int argc, char *argv[])
{
  void triplecol(float *,float *,float *,int,
     float, float, float, float,float []);
  void linfit(float *,float *,int,float *,float *,float *);

  int i,j,k,m,n,np;
  int imon,iw,jw,iy;
  float co_xy,co_xz,co_yz;
  float y_a,y_b,z_a,z_b,t_a,t_b;
  float lin_cal[3],tcem_cal[3];
  float x[NY*NW*NW],y[NY*NW*NW],z[NY*NW*NW];
  float dum1,dum2,dum3,varx,vary,varz;
  unsigned char OneLine1[XDIM],OneLine2[XDIM],OneLine3[XDIM];
  unsigned char ***mod,***vgt,***glc,ch;
  FILE *fm[NY],*fv[NY],*fg[NY],*fnp,*fp1[3],*fp2[3];
  
  mod = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  vgt = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  glc = (unsigned char ***) malloc (sizeof(unsigned char **) *NY);
  for (k=0;k<NY;k++) {
    mod[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    vgt[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    glc[k]=(unsigned char **) malloc (sizeof(unsigned char *) *YDIM);
    for (i=0;i<YDIM;i++) {
      mod[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
      vgt[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
      glc[k][i]=(unsigned char *) malloc (sizeof(unsigned char) *XDIM);
  }}

  for (k=0;k<3;k++) {
    sprintf(fout2,"%s/theta%d.globe.0.05D",fs_out,k);
    fp2[k]=fopen(fout2,"wb");
  }

  for (iy=0;iy<NY;iy++) {
    sprintf(MCD_File,"%s/MCD15.globe.%4d_0.01D",dir_bin,iy+2003);
    sprintf(VGT_File,"%s/VGT.globe.%4d_0.01D",dir_bin,iy+2003);
    sprintf(GC_File,"%s/GC.globe.%4d_0.01D",dir_bin,iy+2003);
    fm[iy]=fopen(MCD_File,"rb");
    fv[iy]=fopen(VGT_File,"rb");
    fg[iy]=fopen(GC_File,"rb");
  } 

  for (imon=0;imon<NMON;imon++) {
    for (i=0;i<YDIM;i++) {
      for (iy=0;iy<NY;iy++) {
        fread(OneLine1,sizeof(unsigned char),XDIM,fm[iy]); 
        fread(OneLine2,sizeof(unsigned char),XDIM,fv[iy]); 
        fread(OneLine3,sizeof(unsigned char),XDIM,fg[iy]); 
        for (j=0;j<XDIM;j++) {
          mod[iy][i][j] = OneLine1[j];
          vgt[iy][i][j] = OneLine2[j];
          glc[iy][i][j] = OneLine3[j];
        }
      }
    }

    for (i=0;i<YDIM-1;i+=NW)
      for (j=0;j<XDIM;j+=NW) { 
        np=0;  
        for (k=0;k<3;k++) {
          tcem_cal[k] = -99.0;
        }

        for (iw=0;iw<NW;iw++)
          for (jw=0;jw<NW;jw++) {

            for (iy=0;iy<NY;iy++) {

              if (mod[iy][i+iw][j+jw] < 180 &&
                vgt[iy][i+iw][j+jw] < 180 &&
                glc[iy][i+iw][j+jw] < 180 && 
                glc[iy][i+iw][j+jw] > 0) {
                  x[np] = (float) mod[iy][i+iw][j+jw] * 0.1;
                  y[np] = (float) vgt[iy][i+iw][j+jw] * 0.1;
                  z[np] = (float) glc[iy][i+iw][j+jw] * 0.1 - 0.1;
                  np++;
              }
            } 
        }

        if (np > NN ) {
          linfit(x,y,np,&co_xy,&y_a,&y_b);
          linfit(x,z,np,&co_xz,&z_a,&z_b);
          linfit(y,z,np,&co_yz,&t_a,&t_b);

          avevar(y,np,&dum2,&vary);
          avevar(z,np,&dum3,&varz);

          if (vary ==0 || varz==0) {
              tcem_cal[0] = 25.4;
              tcem_cal[1] = 25.4;
              tcem_cal[2] = 25.4;
          }
          else if (co_xy >= 0.21 && co_xz >= 0.21 && co_yz >= 0.21)
            triplecol(x,y,z,np,y_a,y_b,z_a,z_b,tcem_cal);
          else {
              tcem_cal[0] = 25.3;
              tcem_cal[1] = 25.3;
              tcem_cal[2] = 25.3;
            }
        }

        for (k=0;k<3;k++) {
          ch = (unsigned char) (tcem_cal[k] * 10);
          fwrite(&ch,sizeof(unsigned char),1,fp2[k]);
        }
    }
  }     
  
  for (iy=0;iy<NY;iy++) {
    fclose(fm[iy]); 
    fclose(fv[iy]); 
    fclose(fg[iy]);
  }
  for (k=0;k<3;k++) {
    fclose(fp2[k]);
  }

}
