/* return field containing calibration and error numbers
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
   
#define XDIM 36000
#define YDIM 13101  /* 56S ~ 75N */
#define NN 20       /* points used in TCEM*/
#define NY 2        /* # of years */
#define NMON 12     /* # of month */
#define NW 5        /* Upscale window size */

char dir_bin[]="/disk2/weiss/Triple/Globe";
char fs_out[]="/disk2/fanghl/Triple/data";
char MCD_File[80],VGT_File[80],GC_File[80];
char fout1[100],fout2[100];

static char f_np[]="/disk2/fanghl/Triple/data/np.globe.0.05D";

main (int argc, char *argv[])
{

  int i,j,k,m,n,np;
  int imon,iw,jw,iy;
  float co_xy,co_xz,co_yz;
  float y_a,y_b,z_a,z_b,t_a,t_b;
  float lin_cal[3],tcem_cal[3];
  float dum1,dum2,dum3,varx,vary,varz;
  
  printf("Initialization\n");

  for (imon=0;imon<NMON;imon++) {

    for (i=0;i<YDIM;i+=NW)
      for (j=0;j<XDIM;j+=NW) { 
        np=0;  
        printf("A%6d%6d",i,j);
        for (iw=0;iw<NW;iw++)
          for (jw=0;jw<NW;jw++) {
            for (iy=0;iy<NY;iy++) {
                  np++;
                  printf("%6d%6d%6d%6d\n",iw,jw,iy,np);
            } 
        }

    }
  }     
  
}
