/*use array x_sig[],y_sig[] instead of scalar */
/* H. Fang, 08.03.2010 */ 
#include <math.h>
   
void triplecol(float *x,float *y,float *z,int ndat,
   float y_a, float y_b, float z_a, float z_b, float cal[3])
{
  void linfit(float *,float *,int,float *,float *,float *);
  float mean(float *,int); 
  void fitexy(float [],float [],int,float [],float [],
     float *,float *,float *,float *,float *,float *);

  int maxiter,iter;
  int i,j,n;
  float eps,x_e,y_e,z_e;
  float y_e_old,z_e_old;
  float x_a,x_b;
  float x_t[ndat],y_t[ndat],z_t[ndat];
  float y_q,z_q,y_chi_sq,z_chi_sq;
  float xx_t[ndat],yy_t[ndat],zz_t[ndat];
  float x_sig[ndat],y_sig[ndat],z_sig[ndat];
  float ay_sigma,az_sigma,by_sigma,bz_sigma;
  float co_xy,co_xz,co_yz;
  float tol;

  eps=0.0001; maxiter=20; iter=0;

  x_e=1000.0; y_e=1000.0; z_e=1000.0;
  x_a=0; x_b=1.0;

/*
  linfit(x,y,ndat,&co_xy,&y_a,&y_b);
  linfit(x,z,ndat,&co_xz,&z_a,&z_b);

  printf("triplecol %6.2f%6.2f%6.2f%6.2f\n",y_a,y_b,z_a,z_b);
*/

  do {

    iter=iter+1;

    y_e_old=y_e;
    z_e_old=z_e;

    for (i=0;i<ndat;i++) {
      x_t[i] = x[i]/x_b - x_a/x_b;
      y_t[i] = y[i]/y_b - y_a/y_b;
      z_t[i] = z[i]/z_b - z_a/z_b;
      xx_t[i] = (x_t[i] - y_t[i]) * (x_t[i] - z_t[i]);
      yy_t[i] = (y_t[i] - x_t[i]) * (y_t[i] - z_t[i]);
      zz_t[i] = (z_t[i] - x_t[i]) * (z_t[i] - y_t[i]);

/*
 printf("%6.2f%6.2f%6.2f",z[i],z_a,z_b); 
 printf("%6.2f%6.2f%6.2f",x_t[i],y_t[i],z_t[i]); 
 printf("%6.2f%6.2f%6.2f\n",xx_t[i],yy_t[i],zz_t[i]); 
*/
    }

    x_e = mean(xx_t,ndat);
    y_e = mean(yy_t,ndat);
    z_e = mean(zz_t,ndat);

/* printf("triplecol A %12.6f%12.6f%12.6f\n",x_e,y_e,z_e);
*/
    if (x_e <= eps) x_e=0.1;
    if (y_e <= eps) y_e=0.1;
    if (z_e <= eps) z_e=0.1;
/*
printf("triplecol B %12.6f%12.6f%12.6f\n",x_b,x_e,z_e);
*/
  for (i=0;i<ndat;i++) {
    x_sig[i] = x_b * sqrt(x_e);
    y_sig[i] = y_b * sqrt(y_e);
    z_sig[i] = y_b * sqrt(z_e);
  }
/*
    x_sig = x_b * sqrt(x_e);
    y_sig = y_b * sqrt(y_e);
    z_sig = z_b * sqrt(z_e);
*/
/*
 printf("A1 x_sig=%8.4f y_sig=%8.4f y_a=%8.4f y_b=%8.4f\n",
       x_sig,y_sig,y_a,y_b);
*/
    fitexy(x,y,ndat,x_sig,y_sig,&y_a,&y_b,&ay_sigma,&by_sigma,&y_chi_sq,&y_q);

/*    x_sig = x_b * sqrt(x_e);
    z_sig = z_b * sqrt(z_e);
*/

/*printf("AA x_sig=%8.4f z_sig=%8.4f z_a=%8.4f z_b=%8.4f\n",
       x_sig,z_sig,z_a,z_b);
*/
    fitexy(x,z,ndat,x_sig,z_sig,&z_a,&z_b,&az_sigma,&bz_sigma,&z_chi_sq,&z_q);
/*
printf("BB %8.4f%8.4f%8.4f%8.4f\n",x_sig,z_sig,z_a,z_b);
printf("CC %4d%12.6f%12.6f%12.6f\n",iter,eps,fabs(y_e-y_e_old),fabs(z_e-z_e_old));
*/
  } while ( (fabs(y_e-y_e_old) <= eps || fabs(z_e-z_e_old) <= eps) && (iter < maxiter) );
/* printf("%6d\n",iter);
*/
  if (iter <= maxiter) 
    {
/* used in main.tcem.c to calculate e 
      cal[0]=sqrt(x_e);
      cal[1]=sqrt(y_e);
      cal[2]=sqrt(z_e);
*/

/* used in main.rmse.c to calculate e*  (USED IN PAPER)
*/ 
      cal[0]=sqrt(x_e) * fabs(x_b);
      cal[1]=sqrt(y_e) * fabs(y_b);
      cal[2]=sqrt(z_e) * fabs(z_b);


/* used in main.theta.c to calculate the hypothetical truth  

      cal[0]=(mean(x,ndat)-x_a)/x_b - sqrt(x_e);
      cal[1]=(mean(y,ndat)-y_a)/y_b - sqrt(y_e);
      cal[2]=(mean(z,ndat)-z_a)/z_b - sqrt(z_e);
*/
    }
  else 
    for (i=0;i<3;i++)
        cal[i]=255;

/*
  for (i=0;i<3;i++) {
      printf("%12.5f",cal[i]);
    printf("\n");
  }
*/

}
