clear all
clc

load ICES2011_cod2532.mat
TSB=Input(:,2)./1000000; % in million tons
landings=Input(:,3)./1000000; % in million tons
escapement=Input(:,4)./1000000; % in million tons
survival=Input(:,5)./1000000; % in million tons
recruitment=Input(:,6)./1000000; % in million tons

Y=log(recruitment);
X=escapement;

% estimation of Beverton-Holt growth function
fprintf('Beverton-Holt Biomass Growth Function\n')
beta=[1.140 1.525];

[betahat,resid,Jacobian,COVBH,mse] = nlinfit(X,Y,@(beta,X)(log(beta(1)*X./(1+beta(2)*X))),beta);
fprintf('estimated parameters\n')
betahat
ciBH = nlparci(betahat,resid,'jacobian',Jacobian,'alpha',0.1);
fprintf('90 percent confidence intervals\n')
ciBH
fprintf('variance-covariance matrix\n')
COVBH

fprintf('DW-test\n')
[P1,DW1] = dwtest(resid,Y)

betahat(1)=betahat(1)*exp(-0.5*mse); % adjust biased estimate of beta(1)

fprintf('\n Harvesting Function\n')

load SSB_Harvest_Effort_data_2009.mat

TSB=SSB_Harvest_Effort(:,2)/1000000; %in million tons
danish_landings=SSB_Harvest_Effort(:,3)/1000000; % in million tons
total_landings=SSB_Harvest_Effort(:,4)/1000000; % in million tons
danish_effort=SSB_Harvest_Effort(:,6)/1000000; % in million days at sea

effort = danish_effort.*total_landings./danish_landings;
escapement = SSB_Harvest_Effort(:,7)/1000000; % in million tons, biomass-(landings+discard)

parameter0=[0.1 0.5];
[HFparams,resid,Jacobian,COVHF]=nlinfit([TSB escapement],effort,...
    @(params,X)(1/(params(1)*(1-params(2)))*(X(:,1).^(1-params(2))-X(:,2).^(1-params(2)))),...
    parameter0);   

fprintf('estimated parameters\n')
HFparams
ciHF = nlparci(HFparams,resid,'jacobian',Jacobian,'alpha',0.1);
fprintf('90 percent confidence intervals\n')
ciHF
fprintf('variance-covariance matrix\n')
COVHF


zeta=0.55;
sdzeta=0.085;

delta=0.05; % interest rate

noofevents=12;
sigma2=log(1+mse);
[z,p]=qnwlogn(noofevents,-0.5*sigma2,sigma2);


nsamples=1000;

betarand = repmat(betahat,nsamples,1) + randn(nsamples,2)*chol(COVBH); 
HFparamsrand = repmat(HFparams,nsamples,1) + randn(nsamples,2)*chol(COVHF); 
zetarand = repmat(zeta,nsamples,1) + randn(nsamples,1)*sdzeta;
optimalEscapements=zeros(2,nsamples);

for i=1:nsamples    
    c=zetarand(i)/HFparamsrand(i,1);
    chi=HFparamsrand(i,2);
%     c=zeta/HFparams(1);
%     chi=HFparams(2);
    beta=betarand(i,:);
    optimalEscapements(1,i)=calc_optimal_escapement(z,p,c,chi,beta,delta);    
    optimalEscapements(2,i)=calc_optimal_escapement(1,1,c,chi,beta,delta);    
end

calc_optimal_escapement(z,p,zeta/HFparams(1),HFparams(2),betahat,delta)
% mean(optimalEscapements)
% std(optimalEscapements)

% cut off outliers
j=1;
for i=1:nsamples    
    if (optimalEscapements(1,i)>0) && (optimalEscapements(1,i)<2) 
        oS(1,j)=optimalEscapements(1,i);
        oS(2,j)=optimalEscapements(2,i);
        j=j+1;    
    end   
end

fprintf('mean optimal escapement\n')
mean(oS(1,:))
fprintf('std optimal escapement\n')
std(oS(1,:))


