function sopt=calc_optimal_escapement(z,p,zeta,chi,beta,delta)

options = optimset('Display','off');
sopt=fsolve(@first_order_condition,1,options);
%Determines the optimal escapement level for a risk neutral decision manager.

function foc=first_order_condition(s)
    g_stoch=ones(size(z))*exp(-0.2)*s+z*((beta(1)*s)/(1+beta(2)*s));
    dg_stoch=ones(size(z))*exp(-0.2)+z*(beta(1)/(1+beta(2)*s)-(beta(1)*beta(2)*s)/((1+beta(2)*s)^2));
    foc=p'*((ones(size(s))-zeta*g_stoch.^(-chi)).*dg_stoch)-(1+delta)*(1-zeta*s^(-chi));
end
end                          


