function sopt=calc_optimal_escapement_both_stochastic(w,pw,z,pz,zeta,chi,beta,delta)

options = optimset('Display','off');
sopt=fsolve(@first_order_condition,1,options);
%Determines the optimal escapement level for a risk neutral decision manager.

%sopt=first_order_condition(.9)
function foc=first_order_condition(s)
    g_stoch=repmat(w',length(z),1)*exp(-0.2)*s+repmat(z,1,length(w))*((beta(1)*s)/(1+beta(2)*s));
    dg_stoch=repmat(w',length(z),1)*exp(-0.2)+repmat(z,1,length(w))*(beta(1)/(1+beta(2)*s)-(beta(1)*beta(2)*s)/((1+beta(2)*s)^2));
    foc=pw'*(pz'*((ones(size(s))-zeta*g_stoch.^(-chi)).*dg_stoch)-(1+delta)*(1-zeta*s^(-chi)))';
end
end                          


