clear all
clc

%
% requires CompEcon toolbox from Miranda and Fackler (2002) and Ziena's
% Knitro solver for optimization problems (ktrlink)
%

%
% Baltic cod
%
beta1=1.140;
beta2=1.525;                    % parameter of Beverton-Holt function
survivalrate=exp(-0.2);
zeta=0.1066;
chi=0.953;

rho=1/1.05;                   % discount factor
theta=0.05;                      % risk aversion fishermen

%Specify nodes and basis for collocation (See also Miranda/Fackler 2002)
Xmin=0.1;
Xmax=5;                       %endpoints of interploation intervall
n=101;                           %number of collocation nodes
fspace=fundefn('cheb',n,Xmin,Xmax);
%CompEcon Toolbox routine to creates a structured variable containing informations about function space
%'Cheb' Chebychev polynomials, n number of basis functions, 
%Xmin, Xmax are the endpoints of the interpolation intervall
Xnodes=funnode(fspace);         %CompEcon Toolbox routine to compute standard nodes for interpolation

clear model
noofevents=3;
%Create a structured variable containing all informations about the model

model.discount=rho;
model.params={zeta chi beta1 beta2 survivalrate theta};
model.n=n;
model.noofevents=noofevents;
% compute events and probabilities from lognormal distribution

varZ=0.0834;
sigma2=log(1+varZ);
[z,p]=qnwlogn(noofevents,-0.5*sigma2,sigma2);
model.e=z;
model.w=p;

% analytic optimum for theta=2, no costs, and no natural mortality
alpha=sqrt(rho*(p'*(1./z))/beta1);
sini=Xnodes;
psi1=((alpha/(1-alpha))^theta)/(rho*(p'*(1./z))/beta1);
psi2=rho/(1-rho)*(p'*(1./z))*beta2^(-1+theta)*psi1/beta1;
vini=-psi1./Xnodes-psi2;

[cini,vini4,sini4]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vini,sini);
vini=vini4;
sini=sini4;

thetas=0.05:0.05:0.5;

copts=zeros(n,length(thetas));
vopts=zeros(n,length(thetas));
sopts=zeros(n,length(thetas));

for i=1:length(thetas)
    theta=thetas(i)
    model.params={zeta chi beta1 beta2 survivalrate theta};
    [copts(:,i),vopts(:,i),sopts(:,i)]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vini,sini);
    vini=vopts(:,i);
    sini=sopts(:,i);
end


thetas2=0.01:0.01:0.05;
copts2=zeros(n,length(thetas2));
vopts2=zeros(n,length(thetas2));
sopts2=zeros(n,length(thetas2));
vini=vini4;
sini=sini4;


for i=1:length(thetas2)
    theta=thetas2(end-i+1)
    model.params={zeta chi beta1 beta2 survivalrate theta};
    [copts2(:,end-i+1),vopts2(:,end-i+1),sopts2(:,end-i+1)]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vini,sini);
    vini=vopts2(:,end-i+1);
    sini=sopts2(:,end-i+1);
end


copts2NU=zeros(n,length(thetas2));
vopts2NU=zeros(n,length(thetas2));
sopts2NU=zeros(n,length(thetas2));

model.noofevents=1;
model.e=1;
model.w=1;
vini=vini4;
sini=sini4;
for i=1:length(thetas2)
    theta=thetas2(end-i+1)
    model.params={zeta chi beta1 beta2 survivalrate theta};
    [copts2NU(:,end-i+1),vopts2NU(:,end-i+1),sopts2NU(:,end-i+1)]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vini,sini);    
    vini=vopts2NU(:,end-i+1);
    sini=sopts2NU(:,end-i+1);
end

%
%
%
%
% no environmental risk
%
%
%
%

fprintf('\n no environmental risk\n\n');

theta=0.1;
clear model

%Create a structured variable containing all informations about the model
model.func='cod_BH_constantmortality';       % model function file that returns the bounds, the reward and the transition function
model.discount=rho;
model.params={zeta chi beta1 beta2 survivalrate theta};
model.n=n;
model.noofevents=1;
% compute events and probabilities from lognormal distribution

model.e=1;
model.w=1;
    
coptsNU=zeros(n,length(thetas));
voptsNU=zeros(n,length(thetas));
soptsNU=zeros(n,length(thetas));
for i=1:length(thetas)    
    theta=thetas(i)
    model.params={zeta chi beta1 beta2 survivalrate theta};
    [coptsNU(:,i),voptsNU(:,i),soptsNU(:,i)]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vopts(:,i),sopts(:,i));
end


coptsNU2=zeros(n,length(thetas2));
voptsNU2=zeros(n,length(thetas2));
soptsNU2=zeros(n,length(thetas2));
for i=1:length(thetas2)    
    theta=thetas2(i)
    model.params={zeta chi beta1 beta2 survivalrate theta};
    [coptsNU2(:,i),voptsNU2(:,i),soptsNU2(:,i)]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vopts2(:,i),sopts2(:,i));
end


%
fprintf('figure 1a\n');

plot([0;Xnodes],[0;sopts(:,1)],[0;Xnodes],[0;soptsNU(:,1)],[0;Xnodes],[0;sopts(:,end)],[0;Xnodes],[0;soptsNU(:,end)])
xlim([0 2])
xlabel('stock biomass [million tons]')
ylabel('optimal escapement [million tons]')

pause 

%
fprintf('figure 1b\n');

plot([0,thetas2,thetas],1000*[0,sopts2(7,:)-sopts2NU(7,:),sopts(7,:)-soptsNU(7,:)],...
    [0,thetas2,thetas],1000*[0,sopts2(19,:)-sopts2NU(19,:),sopts(19,:)-soptsNU(19,:)],...
    [0,thetas2,thetas],1000*[-0.001619,sopts2(41,:)-sopts2NU(41,:),sopts(41,:)-soptsNU(41,:)])
xlabel('coefficient of risk aversion')
ylabel('')
