function [v,vx,vxx] = chebpolys(c,a,b,x)
% defines a linear combination of size(c) univariate chebychev-polynomials
% in x on an interval [a,b]
z = 2*(x-a*ones(size(x)))/(b-a)-ones(size(x));

n=size(c,1);
dz=size(z,2);

% compute chebychev polynomials and derivatives
t(1,:) = ones(dz,1);
t1(1,:) = zeros(dz,1);
t2(1,:) = zeros(dz,1);
t(2,:) = z;
t1(2,:) = ones(dz,1);
t2(2,:) = zeros(dz,1);
for i=3:n
    t(i,:) = 2*z.*t(i-1,:)-t(i-2,:);
    t1(i,:) = 2*t(i-1,:)+2*z.*t1(i-1,:)-t1(i-2,:);
    t2(i,:) = 4*t1(i-1,:)+2*z.*t2(i-1,:)-t2(i-2,:);
end

v=zeros(1,dz);
vx=zeros(1,dz);
vxx=zeros(1,dz);
for i=1:n
    v = v + c(i)*t(i,:);
    vx = vx + c(i)*2/(b-a)*t1(i,:);   % factor 2/(b-a) is derivative of z w.r.t x
    vxx = vxx + c(i)*4/(b-a)^2*t2(i,:); % factor 4/(b-a)^2 is second derivative of z w.r.t x
end
end