function [c,v,S]=collocation_cod_2012(model,Xmin,Xmax,Xnodes,vini,Sini)
%Collocation method adapted from Miranda & Fackler (2002)
%X=fish stock
%S=escapement
%v=value function


rho=model.discount;

zeta=model.params{1};
chi=model.params{2};
beta1=model.params{3};
beta2=model.params{4};
survivalrate=model.params{5};
theta=model.params{6};

p=model.w;
z=model.e;

tol=0.00000001;

%DETERMINE NUMBER OF DIMENSIONS & COORDINATES
n=model.n;  %number of collocation coordinates by state dimension
noofevents=model.noofevents;

Phi=chebmatrix(Xnodes,Xmin,Xmax);   %collocation matrix, generated in a external file
c=Phi\vini;                         %initial basis coefficients

%SOLVE BELLMAN EQUATION

%NEWTON METHOD (see Miranda/ Fackler (2002), p. 228)
for it=1:20                             %perform iteration, max. 10
    c_old=c;                            %store old basis coefficients
    [v,S,vderc]=opt_S(c);             %update value function and policy
    c=c_old-(Phi-vderc)\(Phi*c-v);      %update basis coefficient
    change=norm(c-c_old,inf);           %compute change
    fprintf('%4i %10.1d\n',it,change)    %print progress
    if change<tol, break, end;          %covergence check
end
[v,S]=opt_S(c);             %update value function and policy

%opt_S finds optimal S given v
    function[v,S,vc]=opt_S(c)       %S is initial guess, c a vector of basis coeff.
        S=zeros(size(Sini));
        v=zeros(n,1);
        for iX=1:n %loop over nodes
            [S(iX),v(iX)]=solvebellman(iX,c); %gives optimal S and v at node iX
        end

        vc=zeros(n,n);
        for jz=1:noofevents
            g=z(jz).*beta1*S.*(1+beta2*S).^(-1)+S.*survivalrate;
            vc=vc+p(jz)*rho*chebmatrix(g,Xmin,Xmax);
        end
    end %end function opt_S


    function [S,v]=solvebellman(iX,c)
        %find the S that maximizes value function at node iX
        S0=Sini(iX);
        %options=optimset('Display','off','Algorithm','Active-Set');
        options=optimset('Display','off','Algorithm','Interior-Point');
        [S v]=ktrlink(@objective,S0,[],[],[],[],0,Xnodes(iX),[],options);
        %[S v]=fmincon(@objective,S0,[],[],[],[],0,Xnodes(iX),[],options);
        v=-v;
        
        function util=objective(s)
            x=Xnodes(iX);
            if theta==1            
                if chi==1
                    util=log((x-s)-zeta*log(x./s));              
                else
                    util=log((x-s)-zeta/(1-chi)*(x.^(1-chi)-s.^(1-chi)));                
                end
            else
                if chi==1
                    util=(1/(1-theta))*((x-s)-zeta*log(x./s)).^(1-theta);        
                else
                    util=(1/(1-theta))*((x-s)-zeta/(1-chi)*(x.^(1-chi)-s.^(1-chi))).^(1-theta);        
                end
            end
            for jz=1:noofevents
                util=util+p(jz)*rho*chebpolys(c,Xmin,Xmax,z(jz).*beta1*s.*(1+beta2*s).^(-1)+s.*survivalrate);
            end
            util=-util; %fmincon is a minimizer
        end
    end %end function solvebellman
end
        




